/*
 * ContagionParameters.cpp
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */


#include <ContagionParameters.h>


void clear_epidemic_parameters(contagion_param_struct * cont_param){
	cont_param->T_distr_sample_noise.clear();
	cont_param->norm_distr_sample_noise.clear();
}

double get_rnd_pq_value (vector<double> * sample, double exp_value){

	if (sample->size() == 0){
		return exp_value;
	}

	double gamma = get_random_sample(sample);
	double tmp_rnd_param_value = exp_value + gamma;

	if (tmp_rnd_param_value < 0.0){
		tmp_rnd_param_value = 0.0;
	}else if(tmp_rnd_param_value > 1.0){
		tmp_rnd_param_value = 1.0;
	}

	return tmp_rnd_param_value;
}

int get_T_rnd_sample(vector<double> * T_distr_sample, int T_value){

	if (T_distr_sample->size() == 0){
		return T_value;
	}

	double gamma = get_random_sample(T_distr_sample);
	int T_rnd_value = T_value + (int) round(gamma);
	if (T_rnd_value < 0){
		return 0;
	}

	return T_rnd_value;
}

double get_random_sample(vector<double> * sample){

	int rndIdx = round(my_random_1() * (sample->size()-1));

	return sample->at(rndIdx);
}

int get_random_sample(vector<int> * sample){

	if (sample->size() == 1){
		return sample->at(0);
	}else if (sample->size() == 0){
		printf("ERROR in function get_random_sample, no samples ? \n");
		exit(-1);
	}
	int rndIdx = (int) round(my_random_1() * (sample->size()-1));

	return sample->at(rndIdx);
}

double my_random_1() {
    double scale = RAND_MAX + 1.;
    double base = rand() / scale;
    double fine = rand() / scale;
    return base + fine / scale;
}
